<?php
include_once 'db.php';  

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';

date_default_timezone_set("Asia/Calcutta");
$currentDate = date('Y-m-d');  

// Decode JSON input from AJAX
$requestData = json_decode(file_get_contents('php://input'), true);

// Validate input data - fixed to check for correct user_id field
if (!$requestData || !isset($requestData['user_id']) || empty($requestData['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid or missing user data.']);
    exit;
}

// Extract customer details - fixed variable names to match input data
$userid = $requestData['user_id'] ?? '';
$email = $requestData['email'] ?? '';
$firstName = $requestData['firstName'] ?? '';
$lastName = $requestData['lastName'] ?? '';
$phoneNumber = $requestData['phoneNumber'] ?? '';
$address = $requestData['address'] ?? '';
$apartment = $requestData['apartment'] ?? '';
$city = $requestData['city'] ?? '';
$postalCode = $requestData['postalCode'] ?? '';
$totalAmount = $requestData['totalAmount'] ?? 0;
$gstno = $requestData['gstno'] ?? '';
$payment_id = $requestData['razorpay_payment_id'] ?? '';
$shipping = $requestData['shipping'] ?? 0;
$payment_method = $requestData['payment_method'] ?? 'online'; 
$totalDiscount = $requestData['totalDiscount'] ?? 0;
$country = $requestData['country'] ?? '';
$state = $requestData['state'] ?? '';
$ordernote= $requestData['orderNotes'] ?? '';

// Initialize key variables
$customerid = $userid;
$name = trim($firstName . ' ' . $lastName);
$displayname = $name;

// Fetch existing customer data
$selectCustomer = "SELECT id AS customerid, displayname, address, address2, city, pincode, 
                          saddress, saddress2, scity, spincode, sphoneno, sname 
                   FROM customer 
                   WHERE id = '$customerid'";

$customerResult = mysqli_query($conn, $selectCustomer);

if ($customerResult && mysqli_num_rows($customerResult) > 0) {
    $customerRow = mysqli_fetch_assoc($customerResult);
    
    if (!empty($customerRow['displayname'])) {
        $displayname = $customerRow['displayname'];
    }
    
    // Update address if changed
    $currentBillingAddress = trim($customerRow['address'] . ' ' . $customerRow['address2']);
    $newBillingAddress = trim($apartment . ' ' . $address);
    
    $addressChanged = (
        $currentBillingAddress != $newBillingAddress ||
        $customerRow['city'] != $city ||
        $customerRow['pincode'] != $postalCode ||
        $customerRow['saddress'] != $apartment ||
        $customerRow['saddress2'] != $address ||
        $customerRow['scity'] != $city ||
        $customerRow['spincode'] != $postalCode ||
        $customerRow['sphoneno'] != $phoneNumber ||
        $customerRow['sname'] != $name
    );

    if ($addressChanged) {
        $esc_apartment = mysqli_real_escape_string($conn, $apartment);
        $esc_address = mysqli_real_escape_string($conn, $address);
        $esc_city = mysqli_real_escape_string($conn, $city);
        $esc_postalCode = mysqli_real_escape_string($conn, $postalCode);
        $esc_phoneNumber = mysqli_real_escape_string($conn, $phoneNumber);
        $esc_name = mysqli_real_escape_string($conn, $name);
        
        $updateCustomer = "UPDATE customer SET 
                          saddress2 = '$esc_address',
                          city = '$esc_city',
                          pincode = '$esc_postalCode',
                          saddress = '$esc_apartment',
                          scity = '$esc_city',
                          spincode = '$esc_postalCode',
                          sphoneno = '$esc_phoneNumber',
                          sname = '$esc_name'
                          WHERE id = '$customerid'";
        mysqli_query($conn, $updateCustomer);
    }
}

// Generate new order ID
$lastOrderQuery = "SELECT order_no FROM orders ORDER BY Order_id DESC LIMIT 1";
$lastOrderResult = mysqli_query($conn, $lastOrderQuery);
$lastOrder = mysqli_fetch_assoc($lastOrderResult);
$orderid_str = $lastOrder['order_no'] ?? 'ORD-00000';
$orderNumberParts = explode("-", $orderid_str);
$newOrderID = 'ORD-' . str_pad((int)$orderNumberParts[1] + 1, 5, "0", STR_PAD_LEFT);

$order_db_id = 0;
$invoice_db_id = 0;
$esc_displayname = mysqli_real_escape_string($conn, $displayname);

// Handle COD and Online Payment
if ($payment_method === 'COD') {
    $insertOrder = "INSERT INTO orders (user_id, displayname, order_no, Balance, Grand_total, Action_status, Created_date, Confirmed_date, Store_status, Payment_status, Shipping, Total_saving,ordernote)
                    VALUES ('$customerid', '$esc_displayname', '$newOrderID', '$totalAmount', '$totalAmount', '1', '$currentDate', '$currentDate', '2', '0', '$shipping', '$totalDiscount','$ordernote')";
    mysqli_query($conn, $insertOrder);
    $order_db_id = mysqli_insert_id($conn);

    $lastInvoiceQuery = "SELECT invoice_no FROM invoice ORDER BY invoice_id DESC LIMIT 1";
    $lastInvoiceResult = mysqli_query($conn, $lastInvoiceQuery);
    $lastInvoice = mysqli_fetch_assoc($lastInvoiceResult);
    $invoiceno_str = $lastInvoice['invoice_no'] ?? 'INV-00000';
    $invoiceNumberParts = explode("-", $invoiceno_str);
    $newInvoiceNo = 'INV-' . str_pad((int)$invoiceNumberParts[1] + 1, 5, "0", STR_PAD_LEFT);

    $insertInvoice = "INSERT INTO invoice (invoice_no, Created_date, Balance, user_id, displayname, Grand_total, order_id, Action_status, Store_status, Payment_status, Shipping, Total_saving)
                      VALUES ('$newInvoiceNo', '$currentDate', '$totalAmount', '$customerid', '$esc_displayname', '$totalAmount', '$order_db_id', '1', '2', '0', '$shipping', '$totalDiscount')";
    mysqli_query($conn, $insertInvoice);
    $invoice_db_id = mysqli_insert_id($conn);

    $updateOrder = "UPDATE orders SET Invoice_id = '$invoice_db_id', Payment_id='0' WHERE Order_id = '$order_db_id'";
    mysqli_query($conn, $updateOrder);
} else {
    $insertOrder = "INSERT INTO orders (user_id, displayname, order_no, Balance, Grand_total, Action_status, Created_date, Confirmed_date, Store_status, Payment_status, shipping, Total_saving)
                    VALUES ('$customerid', '$esc_displayname', '$newOrderID', '0', '$totalAmount', '1', '$currentDate', '$currentDate', '2', '1', '$shipping', '$totalDiscount')";
    mysqli_query($conn, $insertOrder);
    $order_db_id = mysqli_insert_id($conn);

    $lastInvoiceQuery = "SELECT invoice_no FROM invoice ORDER BY invoice_id DESC LIMIT 1";
    $lastInvoiceResult = mysqli_query($conn, $lastInvoiceQuery);
    $lastInvoice = mysqli_fetch_assoc($lastInvoiceResult);
    $invoiceno_str = $lastInvoice['invoice_no'] ?? 'INV-00000';
    $invoiceNumberParts = explode("-", $invoiceno_str);
    $newInvoiceNo = 'INV-' . str_pad((int)$invoiceNumberParts[1] + 1, 5, "0", STR_PAD_LEFT);

    $insertInvoice = "INSERT INTO invoice (invoice_no, Created_date, Balance, user_id, displayname, Grand_total, order_id, Store_status, Payment_status, shipping, Total_saving)
                      VALUES ('$newInvoiceNo', '$currentDate', '0', '$customerid', '$esc_displayname', '$totalAmount', '$order_db_id', '2', '1', '$shipping', '$totalDiscount')";
    mysqli_query($conn, $insertInvoice);
    $invoice_db_id = mysqli_insert_id($conn);

    $updatepayment = "INSERT INTO payment (customer_id, Order_id, Invoice_id, Amount, Payment_amount, Payment_type, note, Payment_date, Reference_id)
                      VALUES ('$customerid', '$order_db_id', '$invoice_db_id', '$totalAmount', '$totalAmount', 'razorpay', 'online order', '$currentDate', '$payment_id')";
    mysqli_query($conn, $updatepayment);
    $paymentid1 = mysqli_insert_id($conn);

    $updateOrder = "UPDATE orders SET Invoice_id = '$invoice_db_id', Payment_id='$paymentid1' WHERE Order_id = '$order_db_id'";
    mysqli_query($conn, $updateOrder);
}

// Process products array
foreach ($requestData['products'] as $product) {
    $productId = $product['id'];
    $productName = $product['name'];
    $productUnit = $product['quantity'];
    $productPrice = $product['price'];
    $Tax = $product['tax'];
    $Tax_percentage = $product['tax_percentage'];
    $Discount = $product['discount'];
    $Discount_percentage = $product['discount_percentage'];
    $mrp = str_replace('₹', '', $product['mrp']); 
    $productSubtotal = $product['subtotal'];
    $weight = $product['unit'];

    $insertProduct = "INSERT INTO order_data (Order_id, Product_id, qty, Selling_price, discount, Discount_percentage, MRP, Tax, Tax_percentage, Product_total)
                      VALUES ('$order_db_id', '$productId', '$productUnit', '$productPrice', '$Discount', '$Discount_percentage', '$mrp', '$Tax', '$Tax_percentage', '$productSubtotal')";
    mysqli_query($conn, $insertProduct);

    $insertProductInvoice = "INSERT INTO invoice_data (invoice_id, Product_id, qty, Selling_price, discount, Discount_percentage, MRP, Tax, Tax_percentage, Product_total)
                             VALUES ('$invoice_db_id', '$productId', '$productUnit', '$productPrice', '$Discount', '$Discount_percentage', '$mrp', '$Tax', '$Tax_percentage', '$productSubtotal')";
    mysqli_query($conn, $insertProductInvoice);
    
    $update_product_query = "UPDATE product SET qty = qty - '$productUnit' WHERE Product_id = '$productId'";
    mysqli_query($conn, $update_product_query);

    $update_inventory_query = "UPDATE inventory SET Qty = Qty - '$productUnit', date_modified = NOW() WHERE Product_id = '$productId'";
    mysqli_query($conn, $update_inventory_query);
}

// Send email confirmation
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host       = 'smtp.gmail.com';
    $mail->SMTPAuth   = true;
    $mail->Username   = 'novaronald023@gmail.com';
    $mail->Password   = 'tdow bdbv dsnd xqxe';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
    $mail->Port       = 587;

    $mail->setFrom('novaronald023@gmail.com', 'STS STEELS');
    $mail->addAddress($email, $name);
    $mail->addBCC('novaronald023@gmail.com');

    $mail->isHTML(true);
    $mail->Subject = 'Your Order with STS Steels Has Been Successfully Placed!';
    $html = '<h2>Thank you for starting your dream with STS Steels!</h2>';
    $html .='<br>';
    $html .= '<p>We have successfully received your order #<strong>' . $newOrderID . '</strong> along with your payment of '. number_format($totalAmount, 2) .'.Your order details are being processed, and we will update you once it`s confirmed by our team.</p>';
    $html .= '<h3>Order Summary:</h3>';
    $html .= '<table border="1" cellpadding="5" cellspacing="0" style="width:100%; border-collapse: collapse;"><tr><th style="text-align:left;">Product Name</th><th style="text-align:right;">Quantity</th><th style="text-align:right;">Price in Rupees</th></tr>';
    
    foreach ($requestData['products'] as $product) {
        // Fix for MRP display - properly extract numeric value
        $mrpValue = 0;
        if (isset($product['mrp'])) {
            $mrpValue = (float) preg_replace('/[^0-9.]/', '', $product['mrp']);
        }
        $html .= '<tr><td>' . $product['name'] . '</td><td style="text-align:right;">' . $product['quantity'] . '</td><td style="text-align:right;">' . number_format($mrpValue, 2) . '</td></tr>';
    }
    
    $html .= '</table>';
    $html .= '<p style="text-align:right; font-size:1.2em; margin-top:10px;"><strong>Total: ' . number_format($totalAmount, 2) . '</strong></p>';
    $html .='<br>';
    $html .='<p>If you have any questions, feel free to reach out at sales@sculptengineering.com (or) 04322-221792</p>';
    $html .='<br>';
    $html .='<p>Regards,</p>';
    $html .='<p><strong>Team STS Steels</strong></p>';
    $html .='<p>www.stssteels.com</p>';
    $mail->Body = $html;

    $mail->send();
} catch (Exception $e) {
    error_log("Email could not be sent. Mailer Error: {$mail->ErrorInfo}. Recipient Email: $email");
}

$grandtotal11 = 0;

if ($invoice_db_id) {
    // Fetch profile information
    $querys = mysqli_query($conn, "SELECT * FROM user_profile WHERE User_id = 4");
    if (!$querys) {
        // We shouldn't stop the whole process, but log the error
        error_log('Error fetching profile data: ' . mysqli_error($conn));
    }
    $profileselect = mysqli_fetch_array($querys);

    // Assign profile data to variables with default values
    $storename = $profileselect['store_name'] ?? 'Default Store Name';
    $profile_email = $profileselect['Email'] ?? 'no-reply@example.com';
    $street1 = $profileselect['Address'] ?? '';
    $street2 = $profileselect['street2'] ?? '';
    $profile_city = $profileselect['City'] ?? '';
    $state = $profileselect['State'] ?? '';
    $profile_pincode = $profileselect['Pincode'] ?? '';
    $phonenumber = $profileselect['Phone'] ?? '';
    $store_gstno = $profileselect['gstin'] ?? '';
    $logopath = $profileselect['store_image'] ?? '';
    $accountno = $profileselect['acount_no'] ?? '';
    $ifsc = $profileselect['ifsc'] ?? '';
    $bank = $profileselect['bank_name'] ?? '';
    $upiid = $profileselect['upiid'] ?? '';

    // Fetch invoice information
    $query = mysqli_query($conn, "SELECT i.invoice_id, i.invoice_no, i.Created_date, i.Grand_total,i.Total_saving, c.displayname, c.phonenumber, c.address,c.address2, c.city, c.pincode, c.gstno, c.email, i.order_id, i.user_id
                                  FROM invoice i 
                                  INNER JOIN customer c ON c.id = i.user_id 
                                  WHERE i.invoice_id = '$invoice_db_id'");
    if (!$query) {
         error_log('Error fetching invoice data: ' . mysqli_error($conn));
    }
    $invoice = mysqli_fetch_array($query);
    $grandtotal11 = $invoice['Grand_total'] ?? $totalAmount;
    $invoice_data = $invoice['Created_date'] ?? $currentDate;
    $discount = $invoice['Total_saving'] ?? $totalDiscount;

    // Fetch invoice settings
    $query1 = mysqli_query($conn, "SELECT * FROM invoicesetting WHERE 1");
    if (!$query1) {
        error_log('Error fetching invoice settings: ' . mysqli_error($conn));
    }
    $terms = mysqli_fetch_array($query1);

    $sqlInsert = "INSERT INTO invoicepdfdetails 
                  (invoiceno, invoiceid, orderid, customerid, grandtotal, totalsavings, storename, email, street1, street2, city, state, pincode, phonenumber, gstnumber, logopath, notes, account, ifsc, bankname, displayname, phoneno, address, address2, customer_city, customer_pincode, customer_gstno, customer_email, upiid, terms, qrcode) 
                  VALUES 
                  ('$newInvoiceNo', '$invoice_db_id','$newOrderID', '$customerid', '$grandtotal11', '$discount', '$storename', '$profile_email', '$street1', '$street2', '$profile_city', '$state', '$profile_pincode', '$phonenumber', '$store_gstno', '$logopath', '" . mysqli_real_escape_string($conn, $terms['note'] ?? '') . "', '$accountno', '$ifsc', '$bank', '" . mysqli_real_escape_string($conn, $invoice['displayname'] ?? $displayname) . "', '" . mysqli_real_escape_string($conn, $invoice['phonenumber'] ?? $phoneNumber) . "', '" . mysqli_real_escape_string($conn, $invoice['address'] ?? $apartment) . "', '" . mysqli_real_escape_string($conn, $invoice['address2'] ?? $address) . "', '" . mysqli_real_escape_string($conn, $invoice['city'] ?? $city) . "', '" . mysqli_real_escape_string($conn, $invoice['pincode'] ?? $postalCode) . "', '" . mysqli_real_escape_string($conn, $invoice['gstno'] ?? $gstno) . "', '" . mysqli_real_escape_string($conn, $invoice['email'] ?? $email) . "', '$upiid', '" . mysqli_real_escape_string($conn, $terms['terms'] ?? '') . "', '" . mysqli_real_escape_string($conn, $terms['qrcode'] ?? '') . "')";
    
    if (!mysqli_query($conn, $sqlInsert)) {
        error_log('Error inserting invoice PDF details: ' . mysqli_error($conn));
    }
}

header('Content-Type: application/json');
echo json_encode([
    'status' => 'success',
    'message' => 'Order and invoice created successfully.',
    'order_id' => $order_db_id,
    'invoice_id' => $invoice_db_id,
    'order_no' => $newOrderID,
    'invoice_no' => $newInvoiceNo,
    'grand_total' => $grandtotal11
]);
?>
